﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Web" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>DokEwidencji</title>
	<script runat="server">
 
		void grid1_OnBeforeRow(object sender, RowEventArgs arg)
		{
			RozliczenieSP r = (RozliczenieSP)arg.Row;
			
			DKwotaKsiegi.EditValue = ((IRozliczalnyCy)r.Dokument).KwotaKsiegi;
			ZKwotaKsiegi.EditValue = ((IRozliczalnyCy)r.Zaplata).KwotaKsiegi;
			
			colStrata.EditValue = r.TypRK == TypRoznicyKursowej.Strata ? r.KwotaRK.Value : 0m;
			colZysk.EditValue = r.TypRK == TypRoznicyKursowej.Zysk ? r.KwotaRK.Value : 0m;
		}
		
	</script>
</head>
<body>
	<form method="post" runat="server" id="form">

	<ea:DataContext ID="dc" runat="server" TypeName="Soneta.Ksiega.RozniceKursoweKPiREwidencja,Soneta.Ksiega" Landscape="True" />
	<eb:ReportHeader ID="ReportHeader" runat="server" Title="Różnice kursowe KPiR|Numer dokumentu: {0}|Data wystawienia: {1}|Data operacji: {2}|Opis: {3}" DataMember0="NumerDokumentu" DataMember1="DataDokumentu" DataMember2="DataOperacji" DataMember3="Opis" />

	<ea:Grid runat="server" ID="grid1" DataMember="RozliczeniaRK" RowTypeName="Soneta.Ksiega.RozliczenieSP,Soneta.Ksiega" GroupData0="Dokument.Podmiot" GroupLine="Podmiot: {0}" Sort="Dokument.Podmiot.Kod,Data" ShowGroupSum="True" OnBeforeRow="grid1_OnBeforeRow" EncodeHTML="True" >
		<Columns>
			<ea:GridColumn runat="server" Width="4" Align="Center" DataMember="#" Caption="LP." />
			<ea:GridColumn runat="server" Align="Left"  Caption="Dokument~Numer" DataMember="Dokument.NumerDokumentu" Total="Info" />
			<ea:GridColumn runat="server" Align="Center" Caption="Dokument~Data" DataMember="Dokument.DataDokumentu" Width="11" />
			<ea:GridColumn runat="server" Align="Center" Caption="Dokument~Typ" DataMember="Dokument.Typ" Width="13" />
			<ea:GridColumn runat="server" Align="Right" Caption="Dokument~Kwota w walucie" DataMember="Dokument.Kwota" Width="16" />
			<ea:GridColumn runat="server" Align="Right" Caption="Dokument~Kwota Księgi" ID="DKwotaKsiegi" Width="16" />
			<ea:GridColumn runat="server" Align="Left" Caption="Zapłata~Numer" DataMember="Zaplata.NumerDokumentu" />
			<ea:GridColumn runat="server"  Align="Center" Caption="Zapłata~Data" DataMember="Zaplata.DataDokumentu"  Width="11" BottomBorder="Single" />
			<ea:GridColumn runat="server" Align="Right" Caption="Zapłata~Kwota w walucie" DataMember="Zaplata.Kwota" Width="16" />
			<ea:GridColumn runat="server" Align="Right" Caption="Zapłata~Kwota Księgi" ID="ZKwotaKsiegi" Width="16" />
			<ea:GridColumn Width="14" Align="Right" ID="colZysk" Caption="Różnica kursowa~Zysk" runat="server" HideZero="True" Format="{0:n}" Total="Sum" />
			<ea:GridColumn Width="14" Align="Right" ID="colStrata" Caption="Różnica kursowa~Strata" runat="server" Format="{0:n}" HideZero="True" Total="Sum" />
		</Columns>
	</ea:Grid>
	<eb:ReportFooter ID="ReportFooter" runat="server" />
	</form>
</body>
</html>

